require "prefabutil"

local assets=
{
	Asset( "ANIM", "anim/cs2.zip" ),
	Asset("ANIM", "anim/clearsky.zip"),
	Asset("IMAGE", "images/inventoryimages/cs2.tex"),
	Asset("ATLAS", "images/inventoryimages/cs2.xml"),
}



local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function hurtowner(inst, owner)
	if (owner.components.health) then
		owner.components.health:DoDelta(-1,-1)
end
end

local function ChangeInsulationSW(inst)
if  GetWorld().components.seasonmanager.current_season == SEASONS.DRY then
    inst.components.insulator:SetSummer()
elseif not GetWorld().components.seasonmanager.current_season == SEASONS.DRY then
 	inst.components.insulator:SetWinter()
    end end	


local function ChangeInsulation(inst)
if GetWorld().components.seasonmanager.current_season == SEASONS.SUMMER then
    inst.components.insulator:SetSummer()
elseif not GetWorld().components.seasonmanager.current_season == SEASONS.WINTER then
 	inst.components.insulator:SetWinter()
    end end	

local function onequip(inst, owner) 
    inst:ListenForEvent("blocked", OnBlocked, owner)
	owner:AddTag("antirad")
	ChangeInsulation(inst)
	owner.components.builder.ingredientmod = .5

	if owner.components.health then
		owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale - .5
	end
	
	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
end

local function onunequip(inst, owner) 
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
	owner:RemoveTag("antirad")
	owner.components.builder.ingredientmod = 1
	if owner.components.health then
		owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale + .5
	end
	
	if owner:HasTag("rad") then
	inst.task = inst:DoPeriodicTask(4, hurtowner, nil, owner)
	end
end



local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
        	
    inst.AnimState:SetBank("cs2")
    inst.AnimState:SetBuild("cs2")
    inst.AnimState:PlayAnimation("idle", false)
	
	MakeInventoryPhysics(inst)
	
	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cs2.xml"
    
    inst:AddComponent("armor")
    	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.inventoryitem.keepondeath = true
	
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst.components.armor:InitCondition(1000, 0.65)
	
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
	
inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
	ChangeInsulation(inst)
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_MED)
	
	elseif IsDLCEnabled(0002) then
	inst.components.armor:InitCondition(1000, 0.65)
	
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
		
	inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
	ChangeInsulationSW(inst)
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_MED)
	
	--inst.components.equippable.poisonblocker = true
	inst.components.equippable.poisongasblocker = true
	end
	
	
	
    return inst
end

STRINGS.RECIPE_DESC.CS2 = "Repair your suit\ncompletely."

return Prefab( "common/inventory/cs2", fnab, assets) 